/*
 *  cam_firewire_OSX.h
 *  PHD
 *
 *  Created by Craig Stark on 3/15/07.
 *  Copyright 2007 Craig Stark, Stark Labs. All rights reserved.
 *
 */


#ifndef FIREWIREDEF
#define FIREWIREDEF

#if defined (__APPLE__)
#include <dc1394/control.h>
#include <dc1394/utils.h>
#else
#include "tisudshl.h" 
#endif

class Camera_FirewireClass : public GuideCamera {
public:
	bool	CaptureFull(int duration, usImage& img);	// Captures a full-res shot
//	bool	CaptureCrop(int duration, usImage& img);	// Captures a cropped portion
	bool	Connect();
	bool	Disconnect();
	void	InitCapture();
//	bool	PulseGuideScope(int direction, int duration);
	
	
	Camera_FirewireClass(); 
//	~Camera_FirewireClass(); 
private:
//	bool GenericCapture(int duration, usImage& img, int xsize, int ysize, int xpos, int ypos);
#if defined (__APPLE__)
	dc1394camera_t *camera;
#else
	DShowLib::Grabber* m_pGrabber;
	DShowLib::tFrameHandlerSinkPtr pSink;
	DShowLib::tIVCDAbsoluteValuePropertyPtr  m_pExposureAbs;
	DShowLib::tIVCDRangePropertyPtr  m_pGain;
	long GainMax;
#endif
};
#endif
