#include <wx/minifram.h>

#ifndef GRAPHCLASS
#define GRAPHCLASS

class GraphLogWindow : public wxMiniFrame {
public:
	GraphLogWindow(wxWindow *parent);
	~GraphLogWindow(void);
	void AppendData (float dx, float dy, float RA, float Dec);
	void SetState (bool is_active);
	void OnPaint(wxPaintEvent& evt);
	void OnButtonMode(wxCommandEvent& evt);
	void OnButtonLength(wxCommandEvent& evt);
	void OnButtonHide(wxCommandEvent& evt);

private:
	wxButton *LengthButton;
	wxButton *ModeButton;
	wxButton *HideButton;
//	wxBitmap *bmp;
	float hdx[500];	// History of dx
	float hdy[500];
	float hra[500];
	float hdec[500];
	int n_items;	// # items in the history
	bool visible;
	int mode;	// 0 = RA/Dec, 1=dx, dy
	int length;

/*	float maxdx;	// Max dx
	float maxdy;
	float maxra;
	float maxdec;
	float mindx;	// Min dx
	float mindy;
	float minra;
	float mindec;*/
	DECLARE_EVENT_TABLE()
};

class ProfileWindow : public wxMiniFrame {
public:
	ProfileWindow(wxWindow *parent);
	~ProfileWindow(void);
	void UpdateData(usImage& img, float xpos, float ypos);
	void OnPaint(wxPaintEvent& evt);
	void SetState(bool is_active);
	void OnLClick(wxMouseEvent& evt);	
private:
	int mode; // 0= 2D profile of mid-row, 1=2D of avg_row, 2=2D of avg_col
	bool visible;
	unsigned short *data;
	int horiz_profile[21], vert_profile[21], midrow_profile[21];
	DECLARE_EVENT_TABLE()
};


#endif
