///////////////////////////////////////////////////////////////////////
// Copyright (c) 1998 - 2002 fishcamp engineering
// 
// 
// fishcamp engineering provides this AS IS, WITHOUT ANY WARRANTY, EXPRESS OR
// IMPLIED, INCLUDING, WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY
// OR FITNESS FOR A PARTICULAR PURPOSE.  fishcamp engineering makes no guarantee
// or representations regarding the use of, or the results of the use of,
// the software and documentation in terms of correctness, accuracy,
// reliability, currentness, or otherwise; and you rely on the software,
// documentation and results solely at your own risk.
// 
// IN NO EVENT SHALL FISHCAMP ENGINEERING BE LIABLE FOR ANY LOSS OF USE, LOSS 
// OF BUSINESS, LOSS OF PROFITS, INDIRECT, INCIDENTAL, SPECIAL OR CONSEQUENTIAL
// DAMAGES OF ANY KIND.  IN NO EVENT SHALL FISHCAMP ENGINEERING'S TOTAL LIABILITY 
// EXCEED THE SUM PAID TO FISHCAMP ENGINEERING FOR THE PRODUCT LICENSED HEREUNDER.
// 


///////////////////////////////////////////////////////////////////////
// TestApp2.cpp
//
// Test application for fishcamp engineering's FPCI-DIO card.
//
// This card was designed for simple input/output operations of 32 bit
// digital words.  Data transfers are accomplished via software
// calls to the card's driver or via simple memory READ/WRITE operations.
//
//
// Author:
//		bob piatek
//		fishcamp engineering
//		105 w. clark ave.
//		orcutt, ca  93455
//		805-937-6365
//		bobtek@fishcamp.com
// 
// Revision History:                                                  
//                                                                    
//	   11-10-98 : Release 1.0    fishcamp engineering                 
//     05-06-99 : Release 1.1    updated for Win95/WinNT
//     10-06-02 : Release 1.2    updated for Win2K/WinXP




#include <windows.h>
#include <winioctl.h>
#include <stdio.h>
#include <conio.h>
#include "fcdrintr.h"		// this supplied by fishcamp engineering





////////////
// Global variables

HANDLE	g_hDevice;		// handle to our device
ULONG*	g_pMemLong;		// pointer to memory base of our card



////////////
// Helper routines
//



////////////
// Get a pointer to the user accessible registers on the card.
// This ponter can be used for direct memory access to the card via standard
// 'C' pointer operations.
//
// returns NULL if error
//

ULONG* Get_UM_Pointer()
{
	ULONG*	retVal = NULL;
	BOOL	bRet;
	ULONG*	pMem;
	DWORD	cbRet;

	if (g_hDevice != NULL)
	{
		// Send request to the driver to get user-mode pointer to device memory
		bRet = DeviceIoControl(g_hDevice,
					IOCTL_GET_UM_POINTER,
					NULL,
					0,
					&pMem,
					sizeof(ULONG*),
					&cbRet,
					NULL);

		if (!bRet)
			printf("Failed to get user-mode pointer to memory.\n");
		else
		{
			retVal = pMem;
		}
	}

	return retVal;
}








////////////
// Free the pointer previously gotten via IOCTL_GET_UM_POINTER
//
//
void Free_UM_Pointer(void)
{
	ULONG	nOutput;		// Count written to bufOutput

	// Call device IO Control interface (IOCTL_FREE_UM_POINTER) in driver
	printf("Issuing Ioctl to device - ");
	if (!DeviceIoControl(g_hDevice,
						 IOCTL_FREE_UM_POINTER,
						 NULL,
						 0,
						 NULL,
						 0,
						 &nOutput,
						 NULL)
	   )
	{
		printf("ERROR: Free_UM_Pointer returns %0x.", GetLastError());
	}
}












////////////
// set new port control word
//
//
// This register is cleared to all zeros upon power up.
//
//
VOID SetPortControlWord(ULONG newWord)
{
	DWORD	cbRet;

	if (g_hDevice != NULL)
	{
		DeviceIoControl(g_hDevice,
					IOCTL_SET_PORT_CNTRL_REG,
					&newWord,
					sizeof(ULONG),
					NULL,
					0,
					&cbRet,
					NULL);
	}
}






////////////
// get currently set port control word
//
ULONG GetPortControlWord()
{
	ULONG	retVal;
	BOOL	bRet;
	DWORD	cbRet;

	if (g_hDevice != NULL)
	{
		bRet = DeviceIoControl(g_hDevice,
					IOCTL_GET_PORT_CNTRL_REG,
					NULL,
					0,
					&retVal,
					sizeof(ULONG),
					&cbRet,
					NULL);
		if (!bRet)
			printf("Failed to get port control word.\n");

	}

	return retVal;
}








////////////
// set new port0 data word
//
//
// The data registers are cleared to all zeros upon power up.
//
//
VOID SetPort0DataWord(ULONG newValue)
{
	DWORD	cbRet;

	if (g_hDevice != NULL)
	{
		DeviceIoControl(g_hDevice,
					IOCTL_SET_PORT0_REG,
					&newValue,
					sizeof(ULONG),
					NULL,
					0,
					&cbRet,
					NULL);
	}
}






////////////
// get current port0 data word
//
ULONG GetPort0DataWord()
{
	ULONG	retVal;
	BOOL	bRet;
	DWORD	cbRet;

	if (g_hDevice != NULL)
	{
		bRet = DeviceIoControl(g_hDevice,
					IOCTL_GET_PORT0_REG,
					NULL,
					0,
					&retVal,
					sizeof(ULONG),
					&cbRet,
					NULL);
		if (!bRet)
			printf("Failed to get port data word.\n");

	}

	return retVal;
}







////////////
// set new port1 data word
//
//
// The data registers are cleared to all zeros upon power up.
//
//
VOID SetPort1DataWord(ULONG newValue)
{
	DWORD	cbRet;

	if (g_hDevice != NULL)
	{
		DeviceIoControl(g_hDevice,
					IOCTL_SET_PORT1_REG,
					&newValue,
					sizeof(ULONG),
					NULL,
					0,
					&cbRet,
					NULL);
	}
}






////////////
// get current port1 data word
//
ULONG GetPort1DataWord()
{
	ULONG	retVal;
	BOOL	bRet;
	DWORD	cbRet;

	if (g_hDevice != NULL)
	{
		bRet = DeviceIoControl(g_hDevice,
					IOCTL_GET_PORT1_REG,
					NULL,
					0,
					&retVal,
					sizeof(ULONG),
					&cbRet,
					NULL);
		if (!bRet)
			printf("Failed to get port data word.\n");

	}

	return retVal;
}









////////////
// set new port2 data word
//
//
// The data registers are cleared to all zeros upon power up.
//
//
VOID SetPort2DataWord(ULONG newValue)
{
	DWORD	cbRet;

	if (g_hDevice != NULL)
	{
		DeviceIoControl(g_hDevice,
					IOCTL_SET_PORT2_REG,
					&newValue,
					sizeof(ULONG),
					NULL,
					0,
					&cbRet,
					NULL);
	}
}






////////////
// get current port2 data word
//
ULONG GetPort2DataWord()
{
	ULONG	retVal;
	BOOL	bRet;
	DWORD	cbRet;

	if (g_hDevice != NULL)
	{
		bRet = DeviceIoControl(g_hDevice,
					IOCTL_GET_PORT2_REG,
					NULL,
					0,
					&retVal,
					sizeof(ULONG),
					&cbRet,
					NULL);
		if (!bRet)
			printf("Failed to get port data word.\n");

	}

	return retVal;
}










int main()
{
				OSVERSIONINFO	osInfo;
	volatile	ULONG			aLong;			// need to declare this 'volatile' or the linker
												// will dead-strip the code as unused.
	volatile	ULONG*			cntrlRegPtr;	// pointer to Control Register
	volatile	ULONG*			port0RegPtr;	// pointer to Port 0 Register
	volatile	ULONG*			port1RegPtr;	// pointer to Port 1 Register
	volatile	ULONG*			port2RegPtr;	// pointer to Port 2 Register

				BOOL			gotError;
				ULONG			i;


	g_hDevice = NULL;		// handle to our device
	g_pMemLong = NULL;		// pointer to memory base of our card



	gotError = false;


	// Determine what platform we are on
	memset(&osInfo, 0, sizeof(OSVERSIONINFO));
	osInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&osInfo);

	if (osInfo.dwPlatformId == VER_PLATFORM_WIN32_NT)
	{
		// On WinNT/Win2K/WinXP, open handle to device object
		printf("Opening on WinNT product family....\n");

		// cards will be named 'FPCI-DIOx' where x = 0, 1, 2, ... for successive cards.
		// we will assume we have only one card in the computer.
		g_hDevice = CreateFile("\\\\.\\FPCI-DIO0", 
						GENERIC_READ|GENERIC_WRITE,
						0, 
						NULL, 
						OPEN_EXISTING,
						FILE_ATTRIBUTE_NORMAL, 
						NULL); 
	}
	else
	{
		// On Win95, open handle to VxD
		printf("Opening VxD....\n");

		g_hDevice = CreateFile("\\\\.\\Fcdrv2.vxd",
						0,
						0, 
						NULL, 
						0,
						FILE_FLAG_DELETE_ON_CLOSE,
						NULL); 
	}	










	if (g_hDevice == INVALID_HANDLE_VALUE)
	{
		gotError = true;
		printf("Failed to open handle to device or VxD.\n");
	}
	else
	{
		// OK... we should have opened up the driver to our card when we get here.
		// The first thing to do is to setup the port direction bits in the
		// card control register.  These bits allow the application to select
		// whether the ports are defined as INPUT or OUTPUT signals.
		//
		// First try setting the card's ports to output mode.  We do this by
		// setting the byte direction bits in the control register to 1's.
		// Be carefull here.  Make sure you don't have anything connected to the
		// card's I/O ports since we will be outputting values to the ports that
		// your external equipment may not like.

		aLong = 0x00000fff;			// 3 ports, 4 byte lanes per port, all OUTPUTs
		SetPortControlWord(aLong);

		// read back the control word.  We should get back the same thing that we wrote.
		aLong = GetPortControlWord();
	
		aLong = aLong & 0x0000cfff;	// only 14 bits are valid in this register
		if (aLong != 0x00000fff)
		{
			gotError = true;
			printf("Got ERROR reading back control word - %08x\n", aLong);
		}


		// now try outputting some values to the three ports
		SetPort0DataWord(0x11111111);
		SetPort1DataWord(0x22222222);
		SetPort2DataWord(0x33333333);

		// complete our test by reading back the values

		aLong = GetPort0DataWord();
		printf("Port 0 data - %08x\n", aLong);
		if (aLong != 0x11111111)
			gotError = true;
	
		aLong = GetPort1DataWord();
		printf("Port 1 data - %08x\n", aLong);
		if (aLong != 0x22222222)
			gotError = true;
		
		aLong = GetPort2DataWord();
		printf("Port 2 data - %08x\n", aLong);
		if (aLong != 0x33333333)
			gotError = true;




		// now set port 1 to INPUT and read what is on the port signals.
		// since nothing is connected to the inputs we will see the
		// input signals float to a logic 1.  We should see 0xffffffff come back
		// on port 1.  Ports 0 and 2 should have what they had before.

		aLong = 0x00000f0f;
		SetPortControlWord(aLong);

		// complete our test by reading back the values
		aLong = GetPort0DataWord();
		printf("Port 0 data - %08x\n", aLong);
		if (aLong != 0x11111111)
			gotError = true;
	
		aLong = GetPort1DataWord();
		printf("Port 1 data - %08x\n", aLong);
		if (aLong != 0xffffffff)
			gotError = true;
		
		aLong = GetPort2DataWord();
		printf("Port 2 data - %08x\n", aLong);
		if (aLong != 0x33333333)
			gotError = true;





		printf("hit key to continue: \n\n");
		getch();


		// Now try the same thing but with direct memory I/O operations.
		// this kind of thing is much faster since there is no driver overhead
		// on each data transfer.
		//
		// get a pointer to our card's memory region
		g_pMemLong = Get_UM_Pointer();

		if (g_pMemLong == NULL)
		{
			gotError = true;
			printf("Failed to get user-mode pointer to memory.\n");
		}
		else
		{
			// get base address of our card's registers
			printf("Get_UM_Pointer address = %08x\n", g_pMemLong);
			
			// now setup pointer to the control and port registers on the card
			aLong = (ULONG)g_pMemLong;
			aLong += fc_dio_cntrl_reg_addr;
			cntrlRegPtr = (ULONG*)aLong;

			aLong = (ULONG)g_pMemLong;
			aLong += fc_dio_data_reg0_addr;
			port0RegPtr = (ULONG*)aLong;

			aLong = (ULONG)g_pMemLong;
			aLong += fc_dio_data_reg1_addr;
			port1RegPtr = (ULONG*)aLong;

			aLong = (ULONG)g_pMemLong;
			aLong += fc_dio_data_reg2_addr;
			port2RegPtr = (ULONG*)aLong;

			printf("Card's register addresses:\n");
			printf("   Control Register address = %08x\n", cntrlRegPtr);
			printf("   Port 0 Register address  = %08x\n", port0RegPtr);
			printf("   Port 1 Register address  = %08x\n", port1RegPtr);
			printf("   Port 2 Register address  = %08x\n", port2RegPtr);


			// set the control register to 0x00000fff, all ports as OUTPUT.
			*cntrlRegPtr = 0x00000fff;

			// read back the control word.  We should get back the same thing that we wrote.
			aLong = *cntrlRegPtr;

			aLong = aLong & 0x0000cfff;	// only 14 bits are valid in this register
			if (aLong != 0x00000fff)
			{
				gotError = true;
				printf("Got ERROR reading back control word - %08x\n", aLong);
			}
			

			// now try outputting some data to the ports using direct memory accesses
			*port0RegPtr = 0x44444444;
			*port1RegPtr = 0x55555555;
			*port2RegPtr = 0x66666666;
			
			// complete our test by reading back the values
			aLong = *port0RegPtr;
			printf("Port 0 data - %08x\n", aLong);
			if (aLong != 0x44444444)
				gotError = true;
		
			aLong = *port1RegPtr;
			printf("Port 1 data - %08x\n", aLong);
			if (aLong != 0x55555555)
				gotError = true;
			
			aLong = *port2RegPtr;
			printf("Port 2 data - %08x\n", aLong);
			if (aLong != 0x66666666)
				gotError = true;


			// now set port 1 to INPUT and read what is on the port signals.
			// since nothing is connected to the inputs we will see the
			// input signals float to a logic 1.  We should see 0xffffffff come back
			// on port 1.  Ports 0 and 2 should have what they had before.
			*cntrlRegPtr = 0x00000f0f;

			// complete our test by reading back the values
			aLong = *port0RegPtr;
			printf("Port 0 data - %08x\n", aLong);
			if (aLong != 0x44444444)
				gotError = true;
		
			aLong = *port1RegPtr;
			printf("Port 1 data - %08x\n", aLong);
			if (aLong != 0xffffffff)
				gotError = true;
			
			aLong = *port2RegPtr;
			printf("Port 2 data - %08x\n", aLong);
			if (aLong != 0x66666666)
				gotError = true;


			// setup all ports as outputs
			*cntrlRegPtr = 0x00000fff;

			
			printf("hit key to continue: \n\n");
			getch();




			// for fun, output some patterns to the I/O ports


			// pulse the MSB in the port 2 by setting it high then low.
			*port2RegPtr = 0x00000000;
			*port2RegPtr = 0x80000000;	// high
			*port2RegPtr = 0x00000000;


			// output a 'shifted bit' pattern to port 0.
			aLong = 0x00000001;
			for (i = 0; i < 32; i++)
			{
				*port0RegPtr = aLong;
				aLong = aLong << 1;
			}

	

			// output a 'shifted bit' pattern to port 1.
			aLong = 0x00000001;
			for (i = 0; i < 32; i++)
			{
				*port1RegPtr = aLong;
				aLong = aLong << 1;
			}

	

			// output a 'shifted bit' pattern to port 2.
			aLong = 0x00000001;
			for (i = 0; i < 32; i++)
			{
				*port2RegPtr = aLong;
				aLong = aLong << 1;
			}


			// clean up by freeing the pointer we got earlier
			Free_UM_Pointer();
		}

		CloseHandle(g_hDevice);
	}





	// check for errors
	if (gotError)
		printf("Got ERROR in reading from one of the ports\n");
	else
		printf("Everything looked GREAT!\n");

	
	// wait till user examines output
	printf("hit key to exit: ");
	getch();
	
	return 0;
}
