#include <stdio.h>
#include <errno.h>
#include <linux/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "dio.h"

#define N 1000
/* max size DIO_MAX_BUFF */
#define DEVICE	"/dev/dio"

main(){
int	dev,dev_extra,n,i;
/* note unsigned int is normally __u32 but on some platforms it is __u64
 * so this is why I use sys/types.h __u32 */
__u32	data,d_array[N];	


	printf("Fishcamp DIO driver test / example program\n");
	printf("This will test a few things\n");
	printf("Test 1, concurrent access (banned)\n");
	dev=open(DEVICE,O_RDWR);
	if(dev<0){
		printf("Failed to open the first time\n");
		perror("Error is:");
		exit(0);
		}
	printf("Opened once\n");
	dev_extra=open(DEVICE,O_RDWR);
	if(dev_extra){
		printf("Failed to open the second time\n");
		perror("Reason is:");
		}
	else{
		printf("Succeded the second time (which is bad)\n");
		exit(0);
		}
	printf("Will read the ports once one at a time\n");
	
	/* incase delays are def'd*/
	ioctl(dev,DIO_SET_DELAY,0);
	
	/* set all byte directions to read */
	ioctl(dev,DIO_DIR,0); /* 0=read, 1=write, hence 000000000000 is all read and 111111111111 is all write */

	ioctl(dev,DIO_READ_SEQ,DIO_PORT0);
	read(dev,(void *)&data,sizeof(data));  	
	printf("Read from port 0 %x\n",data);

	ioctl(dev,DIO_READ_SEQ,DIO_PORT1);
	read(dev,(void *)&data,sizeof(data));  	
	printf("Read from port 1 %x\n",data);

	ioctl(dev,DIO_READ_SEQ,DIO_PORT2);
	read(dev,(void *)&data,sizeof(data));  	
	printf("Read from port 2 %x\n",data);

	printf("Reading from ports 0 and 1 together\n");
	ioctl(dev,DIO_READ_SEQ,DIO_PORT0|DIO_PORT1);
	read(dev,(void *)d_array,sizeof(unsigned int)*2);
	printf("Read p0=%x, p1=%x\n",d_array[0],d_array[1]);

	printf("Reading from all ports together\n");
	ioctl(dev,DIO_READ_SEQ,DIO_PORT0|DIO_PORT1|DIO_PORT2); /*note DIO_ALL_PORTS=DIO_PORT0|DIO_PORT1|DIO_PORT2 */
	read(dev,(void *)d_array,sizeof(unsigned int)*3);
	printf("Read p0=%x, p1=%x, p2=%x\n",d_array[0],d_array[1],d_array[2]);
	
	n=N/3;
	printf("Reading from all ports %d times together\n",n);
	ioctl(dev,DIO_READ_SEQ,DIO_PORT0|DIO_PORT1|DIO_PORT2); /*note this is already set...*/
	read(dev,(void *)d_array,sizeof(unsigned int)*n*3);
	printf("The %dth row p0=%x, p1=%x, p2=%x\n",n,d_array[n*3-3],d_array[n*3-2],d_array[n*3-1]);

	/* writes are similar but use write instead- I won't perform all the test because
	 * I don't know what sort of port wiring is going to be in place
	 * I have been using port0 wired to port1 for testing and hence can't write to 0 and 1
	 * at the same time */

	printf("**************\n");
	printf("Testing writes\n");
	printf("Caution: defining port 0 as output\n");	
	ioctl(dev,DIO_DIR,DIO_PORT0); /* since DIO_PORT0=0000000F this sets the DIO_DIR to 000000001111 */
	ioctl(dev,DIO_WRITE_SEQ,DIO_PORT0);
	data=0xf0f0f0f0;
	printf("Writing %x to port 0\n",data);
	write(dev,(void *)&data,sizeof(data));
	printf("Reading port 1\n");
	ioctl(dev,DIO_READ_SEQ,DIO_PORT1);
	read(dev,(void *)&data,sizeof(data));
	printf("Read p1=%x\n",data); 
	
	printf("About to write a sequence to port one word at a time0\n");
	d_array[0]=1;
	for(i=0;i<N;i++){
		data=i;
		write(dev,(void *)&data,sizeof(data));
		d_array[i]=d_array[i-1]<<1;	
		usleep(1); /* this is pretty slow- it is supposed to be 1 microsecond
			    * BUT unless this is running as a real time process
			    * which requires root permission (or setuid(root) usleep
			    * calls schedule/sleep_on which means the minimum delay
			    * in practice is 1/HZ seconds (10ms on an x86) 
			    * see man sched_setscheduler for details of real time processes */	
		}
	/* so I can see this on my led display */
	d_array[N-1]=0xf0f0f0f0;
	printf("About to write a sequence to port0 as a bulk transfer\n");
	write(dev,(void *)d_array,sizeof(__u32)*N);
	printf("Done\n");
	




 	
	}
	
	
	



