/*
   
   Fishcamp DIO card driver for linux
 
   Copyright (C) 2001 Matt Clark matt.clark@nottingham.ac.uk
   Copyright (C) 2001-2002 fishcamp engineering www.fishcamp.com
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

/* these defs are available to user programs */
/* ioctl numbers - arbitrary number here
 * consult Documentation/magic-number.txt
 * if you want to make a more informed choice !
 */
#include <linux/ioctl.h>
#define MAGIC		104

/* make it possible to remove the module if crashed */
#define DIO_HARDRESET		_IO(MAGIC,0)
#define DIO_LATCH		_IO(MAGIC,1)
#define DIO_UNLATCH		_IO(MAGIC,2)
#define DIO_DIR			_IOW(MAGIC,3,0)
#define DIO_READ_SEQ		_IOW(MAGIC,4,0)
#define DIO_WRITE_SEQ		_IOW(MAGIC,5,0)
#define DIO_PARALLEL		_IO(MAGIC,6)
#define DIO_SEQUENTIAL		_IO(MAGIC,7)
#define DIO_SET_DELAY		_IOW(MAGIC,8,0)

/*notice that size of the transfers is 0- call by value */
#define DIO_ALL_READ		0x00000000ul
#define DIO_ALL_WRITE		0x00000FFFul
#define DIO_PORT0		0x0000000Ful
#define DIO_PORT1		0x000000F0ul
#define DIO_PORT2		0x00000F00ul
#define DIO_ALL_PORTS		DIO_PORT0|DIO_PORT1|DIO_PORT2

#define DIO_MAX_BUFF		4096*4/sizeof(__u32)
/* these are not exported to user progs */
#ifdef MODULE

#ifndef DIO_MAJOR
#	define DIO_MAJOR 0
#endif
/* A useful function */
#define is_hex(c)     (((c) >= '0' && (c) <= '9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c) <= 'F'))

/* redfine the name if you like */
#define DIO_MOD_NAME    "dio-fpci"

/* Minor dev numbers, 0->binary access 1,2,4 ports 0,1,2 1+2+4=allports */
#define MINOR_BIN	0
#define MINOR_TEXT	1+2+4 /* just use as a mask */


#ifdef DIO_DEBUG
#	define PRINT_DEBUG(a,args...)	printk(a,## args);
#else 
#	define PRINT_DEBUG(a,args...)
#endif


#define DIO_MOD_NAME		"dio"

/* following are the factory defaults for the DIO */
/* http://www.fishcamp.com/	*/
#define DIO_VENDOR	0x1230
#define DIO_DEVICE	0x0001

/* BOOLs */
#define BOOL	char
#define TRUE	1
#define FALSE 	0

/* a fixed text buffer > sizeof("12345678 12345678 12345678"); */
#define DIO_TEXT_BUFF_SIZE	100

/* I implement a growable buffer to accomodate any transfer size
 * It starts 512 bytes big (size of a sector read) */
#define DIO_BUFFER_SIZE		512/sizeof(u32)
/* enforce a 16k buffer limit- could be 32*PAGE-SIZE/sizeof(u32)
 * or with a bit more design time any size via a linked list
 * but "this will do for now" matt 2001 */
#define DIO_BUFF_LIMIT		PAGE_SIZE*4/sizeof(u32)

/* some defs relating to the hardware */
#define DIO_IO_REGION_SIZE	64*1024 /*64k space */
#define DIO_WORD_SIZE		4
#define DIO_CNTL		0xc000
#define DIO_IO_PORT_0		0x8000
#define DIO_IO_PORT_1		0x8010
#define DIO_IO_PORT_2		0x8020
#define DIO_NO_DIO_PORTS	3	
#define DIO_NO_DIO_BYTES	DIO_NO_DIO_PORTS*DIO_WORD_SIZE
/* first 12 out of 32 bits =FFF bits 1-12 r/w mask, 13 latch, 14 reserved */
/* in the 1st 12 bits a 1 indicates output and 0 input */
#define DIO_CNTL_PORT_MASK	0x00008FFF
#define DIO_CNTL_LATCH_MASK	0x00008000
#define DIO_CNTRL_TEST_MASK	0x00004000
#define DIO_DIR_MASK		0x00000FFF

/* reading and writing applies to all ports selected in these two ints */
static int dio_ports_read	=	DIO_PORT0|DIO_PORT1|DIO_PORT2;
static int dio_ports_write	=	DIO_PORT0|DIO_PORT1|DIO_PORT2;
/* irrespective of the read/write flags a separate direction
 * word is keep, this is what is passed to DIO_IO_CNTL */
static u32 dio_dir;
/* Latching of read is programmable...*/
static u32 dio_latch=FALSE;

/* timing */
/* busy wait for short delays, sleepon for long ones 	*/
/* DIO_USECS_PER_HZ determines the cross over 		*/

/* timing is disabled by default, define DIO_DELAY and 
 * remake the module to enable it-
 * Busy waits are used for (typically) less than 10ms (x86) 
 * (1ms Alphas) */
#define DIO_USECS_PER_HZ	1000000/HZ
static dio_delay_time=0;  

/* driver globals */
static BOOL dio_locked=FALSE;
static void * dio_base=NULL;
static void * dio_cntl=NULL; 
/* how many ports to read/write */
static int dio_n_read=0;
static int dio_n_write=0;


/* private data struct */
/* This could be a static global as we are only opened once at a time */
typedef struct dio_data{
	u32 * buffer;
	int buff_size;
	BOOL eof_next;
	} dio_data_t;


#endif
